import dynamic from "next/dynamic";
// Dynamically import the BlogCard component
import { blogdata } from "@/data/data";
import { domain } from "../domain";
const BlogCard = dynamic(() => import("@/components/BlogCard"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
export const metadata = {
  metadataBase: new URL(`https://${domain}`),
  title: "Palm Jebel Ali News & Launching Update 2025 BT Properties, Dubai",
  description:
    "Discover the latest news, exclusive offers, and investment opportunities in Palm Jebel Ali. Stay informed and make the most of your investments today.",
  keywords: [
    "IRMG news",
    "Palm Jebel Ali News",
    "Palm Jebel Ali Latest Offers",
    "Palm Jebel Ali Investments",
  ],
  alternates: {
    canonical: "/blog",
  },
  openGraph: {
    type: "website",
    siteName: "Palm Jebel Ali",
    url: "/blog",
    images: {
      url: "/images/bhariabac.jpeg",
      width: 100,
      height: 100,
    },
  },
};
export default function page() {
  const { cards } = blogdata;
  return (
    <>
      <WebsiteSchema
        title="Palm Jebel Ali News & Launching Update 2025 BT Properties, Dubai"
        description="Discover the latest news, exclusive offers, and investment opportunities in Palm Jebel Ali. Stay informed and make the most of your investments today."
        keywords={[
          "IRMG news",
          "Palm Jebel Ali News",
          "Palm Jebel Ali Latest Offers",
          "Palm Jebel Ali Investments",
        ]}
        fullUrl={`https://${domain}/blog`}
      />
      <RatingSchema title="Palm Jebel Ali News & Launching Update 2025 BT Properties, Dubai" />
      {/* <!-- Blog 6 - Bootstrap Brain Component --> */}
      <section className="py-3 py-md-5">
        <div className="container">
          <div className="row justify-content-md-center">
            <div className="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
              <h1 className="mb-2 display-5 text-center">Our Blogs</h1>
              <p className="text-secondary mb-5 text-center lead fs-6">
                An exceptional chance to own a villa that combines luxury and
                city accessibility is provided by Palm Jebel Ali Goldmine for
                Investors. This thriving community is a top choice for investors
                because it offers a great living experience along with high
                returns on investment.
              </p>
              <hr className="w-50 mx-auto mb-5 mb-xl-9 border-dark-subtle" />
            </div>
          </div>
        </div>
        <div className="container overflow-hidden">
          <div className="row gy-4 gy-xxl-5">
            {cards.map((items, index) => (
              <BlogCard
                title={items.title}
                discription={items.discription}
                img={items.img}
                date={items.date}
                slug={items.title}
                key={index}
              />
            ))}
          </div>
        </div>
      </section>
    </>
  );
}
