import { domain } from "../domain";
import dynamic from "next/dynamic";
const DSP = dynamic(() => import("@/sections/DSP"));
const Getintu = dynamic(() => import("@/sections/Getintu"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export const metadata = {
  metadataBase: new URL(`https://${domain}`),
  title: "Buy Properties in Palm Jebel Ali",
  description:
    "Buy properties in Palm Jebel Ali. Invest in luxury villas, townhouses, and world-class amenities in a prime, family-friendly community with great ROI potential.",
  keywords: [
    "Properties for Sale in Palm Jebel Ali",
    "Palm jebel ali villas for sale",
    "5 bedroom villas for sale in palm jebel ali",
    "6 bedroom villas for sale in palm jebel ali",
    "7 bedroom villas for sale in palm jebel ali",
  ],
  alternates: {
    canonical: "/buy",
  },
  openGraph: {
    type: "website",
    siteName: "Palm Jebel Ali",
    url: "/buy",
    images: {
      url: "/images/bhariabac.jpeg",
      width: 100,
      height: 100,
    },
  },
};
export default function page() {
  return (
    <>
      <WebsiteSchema
        title="Buy Properties in Palm Jebel Ali"
        description="Buy properties in Palm Jebel Ali. Invest in luxury villas, townhouses, and world-class amenities in a prime, family-friendly community with great ROI potential."
        keywords={[
          "Properties in Palm Jebel Ali,  Buy Property in Palm Jebel Ali",
        ]}
        fullUrl={`https://${domain}/buy`}
      />
      <RatingSchema title="Buy Properties in Palm Jebel Ali" />
      <DSP />
      <Getintu />
    </>
  );
}
