import { domain } from "../domain";
import dynamic from "next/dynamic";

// Dynamic imports for sections and components
const ContactUs = dynamic(() => import("@/sections/ContactUs"));
const Getintu = dynamic(() => import("@/sections/Getintu"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export const metadata = {
  metadataBase: new URL(`https://${domain}`),
  title: "Contact Us",
  description: "",
  keywords: [""],
  alternates: {
    canonical: "/contact-us",
  },
  openGraph: {
    type: "website",
    siteName: "Palm Jebel Ali",
    url: "/contact-us",
    images: {
      url: "/images/bhariabac.jpeg",
      width: 100,
      height: 100,
    },
  },
};
export default function page() {
  return (
    <>
      <WebsiteSchema
        title="Contact Us"
        description=""
        keywords=""
        fullUrl={`https://${domain}/contact-us`}
      />
      <RatingSchema title="Contact Us" />
      <ContactUs />
      <Getintu />
    </>
  );
}
