import "@/style/_index.scss";
import "react-international-phone/style.css";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import dynamic from "next/dynamic";
import localFont from "next/font/local";
import { ModalProvider } from "@/context/ModalContext";
import { CountryProvider } from "@/context/CountryContext";
import { domain } from "./domain";
const WhatsappBtn = dynamic(() => import("@/components/layout/WhatsappBtn"));
const Header = dynamic(() => import("@/components/layout/Header"));
const poppins = localFont({
  src: "./font/myanmar_mn.ttf",
  variable: "--font-poppins",
});
export const metadata = {
  robots: {
    index: true,
    follow: true,
  },
  verification: {
    google: "FpMndiEw4wTJMr1-tRVTkGpCMsi_CoGBVCsHXEvRSIs",
    yandex: "306ae0966dd53315",
    other: {
      "msvalidate.01": ["9A28A415CD5303F8A6F41D2624BC5DD2"],
    },
  },
};
export default function RootLayout({ children }) {
  const currentYear = new Date().getFullYear();
  return (
    <html lang="en">
      <body className={poppins.variable}>
        <CountryProvider>
          <ModalProvider>
            <Header />
            {children}
            <div className="container-fluid footer">
              <div className="w-100 d-flex justify-content-center align-items-center p-3 fs-6">
                <a href="/" className="text-white">
                  &copy; {domain} {currentYear}
                </a>
              </div>
            </div>
          </ModalProvider>
        </CountryProvider>
        <WhatsappBtn />
      </body>
    </html>
  );
}
