import dynamic from "next/dynamic";
const About = dynamic(() => import("@/sections/About"));
const About2 = dynamic(() => import("@/sections/About2"));
const Gallery = dynamic(() => import("@/sections/Gallery"));
const Hero = dynamic(() => import("@/sections/Hero"));
const Nearby = dynamic(() => import("@/sections/Nearby"));
const Getintu = dynamic(() => import("@/sections/Getintu"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const FloorPlan = dynamic(() => import("@/sections/FloorPlan"));
const PaymentPlan = dynamic(() => import("@/sections/PaymentPlan"));
const VillasSection = dynamic(() => import("@/sections/VillasSection"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
import { domain } from "./domain";
export const metadata = {
  metadataBase: new URL(`https://${domain}`),
  title: "palm-jabel-ali.com Dubai Villas & Plots For Sale",
  description:
    "Palm Jebel Ali Nakheel offers luxuary waterfront 5 bed room villas, apartments and a luxurious lifestyle on Dubai’s iconic, palm-shaped island with stunning Gulf views and world-class amenities - palm-jebel-ali villas for sale in dubai",
  keywords: [
    "Palm Jabel Ali Projects",
    "Houses for sale on the palm dubai",
    "Palm jebel ali villas",
    "Palm jebel ali apartments",
    "Property in Palm Jebel Ali",
  ],
  alternates: {
    canonical: "/",
  },
  openGraph: {
    type: "website",
    siteName: "Palm Jebel Ali",
    url: "/",
    images: {
      url: "/images/bhariabac.jpeg",
      width: 100,
      height: 100,
    },
  },
};
export default function Home() {
  return (
    <>
      <WebsiteSchema
        title="palm-jabel-ali.com Dubai Villas & Plots For Sale"
        description="Description: Palm Jebel Ali has officially announced luxury villas in Dubai South. 6.5 Marla villas for sale in Dubai South"
        keywords={[
          "Palm Jebel Ali, Palm Jebel Ali Location, Palm Jebel Ali at Dubai South, Palm Jebel Ali Coming soon, Palm Jebel Ali Payment Plan, Palm Jebel Ali Floor Plan, Palm Jebel Ali Prices",
        ]}
        fullUrl={`https://${domain}`}
      />
      <RatingSchema title="palm-jabel-ali.com Dubai Villas & Plots For Sale" />
      <Hero />
      <About />
      <About2 />
      <VillasSection />
      <PaymentPlan />
      <FloorPlan />
      <Nearby />
      <Gallery />
      <Getintu />
    </>
  );
}
