import React from "react";
import { domain } from "../domain";
import dynamic from "next/dynamic";
const WhyAbout = dynamic(() => import("@/sections/WhyAbout"));
const Faqs = dynamic(() => import("@/sections/Faqs"));
const Getintu = dynamic(() => import("@/sections/Getintu"));
const WebsiteSchema = dynamic(() =>
  import("@/components/Schema/WebsiteSchema")
);
const FaqsSchema = dynamic(() => import("@/components/Schema/FaqsSchema"));
const RatingSchema = dynamic(() => import("@/components/Schema/RatingSchema"));
export const metadata = {
  metadataBase: new URL(`https://${domain}`),
  title: "Why Invest in Palm Jebel Ali",
  description:
    "Invest in Palm Jebel Ali for high ROI, a prime location in Dubai South, luxury living, and unique investment opportunities.",
  keywords: [
    "Why Invest in Palm Jebel Ali, Invest in Palm Jebel,Invest in Palm Jebel",
  ],
  alternates: {
    canonical: "/why-invest-in-palm-jebel-ali",
  },
  openGraph: {
    type: "website",
    siteName: "Palm Jebel Ali",
    url: "/why-invest-in-palm-jebel-ali",
    images: {
      url: "/images/bhariabac.jpeg",
      width: 100,
      height: 100,
    },
  },
};
export default function page() {
  return (
    <>
      <WebsiteSchema
        title="Why Invest in Palm Jebel Ali"
        description="Invest in Palm Jebel Ali for high ROI, a prime location in Dubai South, luxury living, and unique investment opportunities."
        keywords={["Why Invest in Palm Jebel Ali, Invest in Palm Jebel Ali"]}
        fullUrl={`https://${domain}/why-invest-in-palm-jebel-ali`}
      />
      <RatingSchema title="Why Invest in Palm Jebel Ali" />
      <FaqsSchema />
      <WhyAbout />
      <Faqs />
      <Getintu />
    </>
  );
}
