import React from "react";
import { FaTimes } from "react-icons/fa";

export default function Modal({ show, setShow, title, children }) {
  return (
    <div className={`modal_container ${show ? "show" : ""}`}>
      {show && (
        <div
          className="modal fade show d-block"
          tabIndex="-1"
          style={{ background: "rgba(0, 0, 0, 0.5)" }}
        >
          <div className="modal-dialog">
            <div className="modal-content">
              <div className="modal-header">
                <div>
                  <h5 className="mt-2 mb-2">{title}</h5>
                  <p className="mt-2 mb-2">
                    Fill out the form for exclusive property details. Our team
                    will assist you in finding your perfect home!
                  </p>
                </div>
                <button
                  type="button"
                  className="close"
                  onClick={() => setShow(false)}
                >
                  <FaTimes />
                </button>
              </div>
              <div className="modal-body">{children}</div>
            </div>
          </div>
        </div>
      )}
    </div>
  );
}
