import { FaWhatsapp } from "react-icons/fa";
import { IoBedOutline, IoLocationOutline } from "react-icons/io5";
import { SlSizeFullscreen } from "react-icons/sl";
import { HiOutlineMail } from "react-icons/hi";
import Image from "next/image";
import { domain } from "@/app/domain";
import { useModal } from "@/context/ModalContext";
const OffPlanCard = ({
  types,
  bedroom,
  img,
  price,
  location,
  property_name,
  size,
  para,
  developer,
}) => {
  const { toggleModal } = useModal();
  return (
    <div className="new-card m-2">
      <Image
        src={img}
        alt={property_name}
        className="new-card__image"
        width={400}
        height={300}
      />
      <div className="new-card__content">
        <h3 className="new-card__title">{property_name}</h3>
        <p className="new-card__details">{para}</p>
        <p className="new-card__details price text-dark">{price}</p>
        <p className="new-card__details d-flex align-items-center gap-2">
          <IoBedOutline /> {bedroom} <SlSizeFullscreen /> {size}
        </p>
        <p className="new-card__details">
          <IoLocationOutline /> {location}
        </p>
        <div className="new-card__button-group">
          <button
            onClick={() =>
              toggleModal(
                "Need Prompt Consultation?",
                para,
                price,
                bedroom,
                size,
                location,
                types,
                developer,
                `https://${domain}`
              )
            }
          >
            <HiOutlineMail /> Email
          </button>
          <a
            href={`https://wa.me/971524474422?text=Hi+There%2C+I%27m+interested+in+${para}.+Kindly+send+me+more+information.+Thank+you%21+https://${domain}&type=phone_number&app_absent=0`}
          >
            <button>
              <FaWhatsapp /> Whatsapp
            </button>
          </a>
          <a
            onClick={() =>
              toggleModal(
                "Enquire Now!",
                para,
                price,
                bedroom,
                size,
                location,
                types,
                developer,
                `https://${domain}`
              )
            }
          >
            <button>Enquire Now!</button>
          </a>
        </div>
      </div>
    </div>
  );
};

export default OffPlanCard;
