import { WhyInvest } from "@/data/data";
export default function FaqsSchema() {
  const mainEntity = WhyInvest?.map((item) => ({
    "@type": "Question",
    name: item.title,
    acceptedAnswer: {
      "@type": "Answer",
      text: item.description,
    },
  }));
  const Json = {
    "@context": "http://schema.org",
    "@type": "FAQPage",
    mainEntity: mainEntity, // Correct usage
  };
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(Json) }}
    />
  );
}
