// Website Schema
export default function WebsiteSchema({
  title,
  description,
  keywords,
  fullUrl,
  logo,
}) {
  const Json = {
    "@context": "http://schema.org",
    "@type": "WebSite",
    "@id": "#website",
    headline: title,
    url: fullUrl,
    keywords: keywords,
    description: description,
    inLanguage: {
      "@type": "Language",
      name: ["en"],
    },
    copyrightHolder: {
      "@type": "Organization",
      name: title,
      logo: "/images/logo.png",
      url: fullUrl,
      contactPoint: {
        "@type": "ContactPoint",
        telephone: "+971 52 447 4422",
        contactType: "Sales",
        email: "info@uae-offplan.com",
        areaServed: "UAE",
      },
      address: {
        "@type": "PostalAddress",
        addressCountry: "UAE",
        addressLocality: "Dubai",
        addressRegion: "Dubai",
        postalCode: "",
        streetAddress: "",
      },
    },
  };
  return (
    <script
      type="application/ld+json"
      dangerouslySetInnerHTML={{ __html: JSON.stringify(Json) }}
    />
  );
}
