"use client";
import { useState } from "react";
import Image from "next/image";
import { IoMdClose } from "react-icons/io";
import { RiMenu3Fill } from "react-icons/ri";
import { useModal } from "@/context/ModalContext";
import Link from "next/link";
export default function Header() {
  const { toggleModal } = useModal();
  const [navState, SetnavState] = useState(false);
  return (
    <>
      <header className="DetailHeader-container py-0">
        <div className="d-none d-lg-block d-xl-block">
          <nav className="navbar navbar-expand-lg navbar-dark p-0">
            <a className="navbar-brand" href="/">
              <img
                src="/images/logo.png"
                alt="logo"
                className="logo_img mt-3"
              />
            </a>
            <button
              className="navbar-toggler"
              type="button"
              data-toggle="collapse"
              data-target="#navbarNav"
              aria-controls="navbarNav"
              aria-expanded="false"
              aria-label="Toggle navigation"
            >
              <span className="navbar-toggler-icon"></span>
            </button>
            <div className="collapse navbar-collapse" id="navbarNav">
              <ul className="navbar-nav ml-auto text-uppercase">
                <li className="nav-item">
                  <Link className="nav-link" href="/">
                    HOME
                  </Link>
                </li>
                <li className="nav-item">
                  <Link
                    className="nav-link"
                    href="/why-invest-in-palm-jebel-ali"
                  >
                    Why Invest
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href="/buy">
                    Buy
                  </Link>
                </li>
                {/* <li className="nav-item">
                  <Link className="nav-link" href="/blog">
                    Blogs
                  </Link>
                </li> */}
                <li className="nav-item">
                  <Link className="nav-link" href="/privacy-policy">
                    Privacy Policy
                  </Link>
                </li>
                <li className="nav-item">
                  <Link className="nav-link" href="/contact-us">
                    Contact
                  </Link>
                </li>
              </ul>
            </div>
            <a onClick={() => toggleModal("Make an Apointment")}>
              <button className="webbutton header-btn">
                Make an Apointment
              </button>
            </a>
          </nav>
        </div>
        {/* Mobile Headder  */}
        <div className="mobile_header d-block d-lg-none d-xl-none">
          <div className="container-fluid p-0">
            <div className="col-12 d-flex justify-content-between px-4 py-2 header-pading align-items-center">
              <a href="/">
                <Image
                  src="/images/logo.png"
                  width={200}
                  height={80}
                  alt="logo2"
                  className="Mlogo_img"
                />
              </a>
              <div className="toggle_menu">
                <RiMenu3Fill onClick={() => SetnavState(true)} />
              </div>
            </div>
          </div>
          <div className={`menu ${navState ? "menu-visible" : ""}`}>
            <IoMdClose onClick={() => SetnavState(false)} />
            <ul className="menu-inner">
              <li className="menu-item">
                <a href="/" className="menu-logo">
                  <Image
                    src="/images/logo.png"
                    width={200}
                    height={80}
                    alt="logo"
                    className="logo_img"
                  />
                </a>
              </li>
              <li className="menu-item">
                <Link href="/" className="menu-link">
                  Home
                </Link>
              </li>
              <li className="menu-item">
                <Link
                  href="/why-invest-in-palm-jebel-ali"
                  className="menu-link"
                >
                  Why Invest
                </Link>
              </li>
              <li className="menu-item">
                <Link href="/buy" className="menu-link">
                  Buy
                </Link>
              </li>
              <li className="menu-item">
                <Link href="/blog" className="menu-link">
                  Blog
                </Link>
              </li>
              <li className="menu-item">
                <Link href="/privacy-policy" className="menu-link">
                  Privacy Policy
                </Link>
              </li>
              <li className="menu-item">
                <Link className="menu-link" href="/contact-us">
                  Contact
                </Link>
              </li>
            </ul>
          </div>
        </div>
      </header>
    </>
  );
}
