"use client";
import { createContext, useContext, useState, useEffect } from "react";
import axios from "axios";
const CountryContext = createContext();
const CURRENT_COUNTRY_URL = "https://ipinfo.io/?token=4201293edb2459";
export const CountryProvider = ({ children }) => {
  const [countryData, setCountryData] = useState(null);
  useEffect(() => {
    const fetchCountry = async () => {
      try {
        const response = await axios.get(CURRENT_COUNTRY_URL);
        setCountryData(response.data.country.toLowerCase() || null);
      } catch (error) {
        console.error("Error fetching current country info:", error);
        setCountryData(null);
      }
    };
    fetchCountry();
  }, []);

  return (
    <CountryContext.Provider value={countryData}>
      {children}
    </CountryContext.Provider>
  );
};

export const useCountry = () => useContext(CountryContext);
