"use client";
import { useModal } from "@/context/ModalContext";
import Link from "next/link";

export default function DSP() {
  const { toggleModal } = useModal();
  return (
    <>
      <section className="mt-5">
        <div className="container-fluid">
          <div className="container">
            <div className="row">
              <div className="col-lg-6 d-flex align-items-center">
                <div>
                  <h1 className="mb-3">
                    Properties for sale in Palm Jebel Ali
                  </h1>
                  <p>
                    Palm Jebel Ali offers an exceptional selection of properties
                    for sale, providing an unparalleled opportunity to own a
                    luxury home in one of Dubai's most prestigious waterfront
                    communities. The development features a variety of options,
                    from grand<a href="/buy"> 5,6 & 7 bedroom villas,</a> with
                    unique architectural styles in the Beach Villas and Coral
                    Villas collections. These properties are designed to
                    maximize breathtaking sea views and seamless indoor-outdoor
                    living. In addition to villas, Palm Jebel Ali also offers
                    modern townhouses and apartments, ideal for those seeking
                    upscale living with easy access to world-class amenities
                    such as marinas, shopping malls, and leisure facilities.
                    <br />
                    <br />
                    Located near Dubai Marina and The Palm,
                    <a href="/"> Palm Jebel Ali Projects </a> provides residents
                    with a prime location, stunning views, and direct access to
                    the beach. The community is committed to sustainability,
                    with a focus on eco-friendly living, including renewable
                    energy for public facilities. With flexible payment plans
                    and high investment potential, Properties for sale in Palm
                    Jebel Ali offer both a luxurious lifestyle and long-term
                    value. Whether you're looking to invest in a luxurious villa
                    or a stylish apartment, Palm Jebel Ali promises a unique and
                    premium living experience in one of Dubai's most
                    sought-after locations.
                  </p>
                  <a onClick={() => toggleModal("Get in touch")}>
                    <button className="webbutton mt-3">Get in touch</button>
                  </a>
                </div>
              </div>
              <div className="col-lg-6">
                <img
                  src="/images/bhariabac.jpg"
                  className="conatin w-100 h-100 object-fit-cover mt-3"
                />
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
