"use client";
import React from "react";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination } from "swiper/modules";

const Gallery = () => {
  const images = [
    {
      img: "/images/Dubai-Luxury-Property.jpg",
    },
    {
      img: "/images/Palm-Jebel-Ali-Villas-Banner.jpg",
    },
    {
      img: "/images/palm-jebel-ali00_890x440.jpg",
    },
    {
      img: "/images/Palmfeature.jpg",
    },
    {
      img: "/images/bhariabac.jpg",
    },
  ];

  return (
    <section>
      <div className="gallery-section container" id="gallery">
        <h6 className="text-center mb-4">Palm Jebel Ali Gallery</h6>
        <div className="container">
          <Swiper
            style={{
              "--swiper-navigation-color": "#fff",
              "--swiper-pagination-color": "#fff",
            }}
            navigation={true}
            pagination={{
              clickable: true,
            }}
            modules={[Navigation, Pagination]}
            className="mySwiper ourswiper"
          >
            {images.map((item, index) => (
              <SwiperSlide key={index}>
                <img
                  src={item.img}
                  alt={`Slide ${index + 1}`}
                  className="w-100 h-100 object-fit-cover"
                />
              </SwiperSlide>
            ))}
          </Swiper>
        </div>
      </div>
    </section>
  );
};

export default Gallery;
