"use client";
import { useModal } from "@/context/ModalContext";
import CardComponent from "../components/CardComponent";
import { whyInvest } from "@/data/data";
export default function PaymentPlan() {
  const { toggleModal } = useModal();
  return (
    <>
      <section className="PaymentPlan" id="payment-plan">
        <h2 className="text-center mb-4">
          Palm Jebel ali Prices and Payment Plan
        </h2>
        <p className="text-center para">
          <a href={whyInvest}>Investing in Palm Jebel Ali Villas </a> a
          luxurious development by Nakheel, is made easier with flexible and
          tailored payment plans. These detailed payment options are designed to
          make owning your dream home in this exclusive community hassle-free,
          allowing you to explore various plans and turn your dream of
          waterfront living into reality.
        </p>
        <div className="container mt-5 text-center">
          <div className="row justify-content-center ">
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"On Booking"}
                icon="/images/money.png"
                price="20%"
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"During Construction"}
                icon="/images/construction.png"
                price="60%"
              />
            </div>
            <div className="col-md-3 col-sm-6 col-12">
              <CardComponent
                heading={"Post Handover"}
                icon="/images/user-hand.png"
                price="20%"
              />
            </div>
          </div>
          <a onClick={() => toggleModal("Price Available Units")}>
            <button className="webbutton mt-3 mx-auto">
              Price Available Units
            </button>
          </a>
        </div>
      </section>
    </>
  );
}
